/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.kubeutils.kubejs.modules;

import dev.latvian.mods.kubejs.level.ServerLevelJS;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.phys.AABB;
import pro.mikey.kubeutils.KubeUtils;

public class LevelKu {
    private static final ResourceLocation UNKNOWN = new ResourceLocation(KubeUtils.getId(), "unknown");
    private final ServerLevel level;

    public LevelKu(ServerLevelJS level) {
        this.level = level.getMinecraftLevel();
    }

    public void spawnStructure(String structureFile, BlockPos spawnLocation) {
        ResourceLocation structureLocation = new ResourceLocation(structureFile);
        Optional structureTemplate = this.level.m_142572_().m_129909_().m_163774_(structureLocation);
        structureTemplate.ifPresent(e -> e.m_74536_((ServerLevelAccessor)this.level, spawnLocation, spawnLocation, new StructurePlaceSettings(), this.level.f_46441_, 3));
    }

    public List<LivingEntity> findEntitiesWithinRadius(ResourceLocation entityId, BlockPos start, int range) {
        AABB boundingBox = new AABB(start).m_82400_((double)range);
        ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
        for (Entity current : this.level.m_142646_().m_142273_()) {
            ResourceLocation registryName;
            if (!(current instanceof LivingEntity) || (registryName = current.m_6095_().getRegistryName()) == null || !registryName.equals((Object)entityId) || !boundingBox.m_82390_(current.m_20182_())) continue;
            entities.add((LivingEntity)current);
        }
        return entities;
    }

    @Nullable
    public List<BlockPos> findBlockWithinRadius(BlockState block, BlockPos start, int range, boolean absolute) {
        Iterator iterator = BlockPos.m_121919_((BoundingBox)new BoundingBox(start).m_191961_(range)).iterator();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        while (iterator.hasNext()) {
            BlockPos current = (BlockPos)iterator.next();
            if (!absolute && this.level.m_8055_(current).m_60734_() == block.m_60734_()) {
                positions.add(current.m_7949_());
                continue;
            }
            if (!absolute || this.level.m_8055_(current) != block) continue;
            positions.add(current.m_7949_());
        }
        return positions;
    }

    public BlockPos getRandomLocation(BlockPos playerPos, int min, int max) {
        Random randomSource = this.level.f_46441_;
        BoundingBox insideBox = new BoundingBox(playerPos).m_191961_(min);
        BoundingBox outsideBox = new BoundingBox(playerPos).m_191961_(max);
        float xRandom = Mth.m_144924_((Random)randomSource, (float)outsideBox.m_162395_(), (float)outsideBox.m_162399_());
        float yRandom = Mth.m_144924_((Random)randomSource, (float)outsideBox.m_162396_(), (float)outsideBox.m_162400_());
        float zRandom = Mth.m_144924_((Random)randomSource, (float)outsideBox.m_162398_(), (float)outsideBox.m_162401_());
        for (int tries = 0; tries < 50; ++tries) {
            Vec3i newPos = new Vec3i((double)xRandom, (double)Mth.m_14036_((float)yRandom, (float)this.level.m_141937_(), (float)this.level.m_151558_()), (double)zRandom);
            if (insideBox.m_71051_(newPos)) continue;
            return new BlockPos(newPos.m_123341_(), newPos.m_123342_(), newPos.m_123343_());
        }
        return playerPos.m_142022_((double)xRandom, (double)yRandom, (double)zRandom);
    }

    public List<BlockPos> seekCollectionOfBlocks(BlockPos startingPos, int range, Predicate<BlockPos> validator, @Nullable Predicate<BlockPos> belowValidator) {
        BlockPos bottom;
        BoundingBox box = new BoundingBox(startingPos).m_191961_(range);
        List<BlockPos> blockPosStream = BlockPos.m_121919_((BoundingBox)box).map(BlockPos::m_7949_).toList();
        if (!blockPosStream.stream().allMatch(validator)) {
            return new ArrayList<BlockPos>();
        }
        if (belowValidator != null && !belowValidator.test(bottom = new BlockPos(box.m_162395_() + (box.m_162399_() - box.m_162395_() + 1) / 2, box.m_162396_() - 1, box.m_162398_() + (box.m_162401_() - box.m_162398_() + 1) / 2))) {
            return new ArrayList<BlockPos>();
        }
        return blockPosStream;
    }

    public boolean isStructureAtLocation(BlockPos pos, ResourceLocation structureId) {
        ConfiguredStructureFeature configuredStructureFeature = (ConfiguredStructureFeature)this.level.m_142572_().m_206579_().m_175515_(Registry.f_122882_).m_7745_(structureId);
        if (configuredStructureFeature == null) {
            return false;
        }
        return this.level.m_8595_().m_207785_(pos, configuredStructureFeature).m_73603_();
    }

    public Set<ConfiguredStructureFeature<?, ?>> getStructuresAtLocation(BlockPos pos) {
        return this.level.m_8595_().m_207815_(pos).keySet();
    }

    public List<ResourceLocation> getStructureIdsAtLocation(BlockPos pos) {
        return this.getStructuresAtLocation(pos).stream().map(e -> e.f_65403_.getRegistryName() == null ? UNKNOWN : e.f_65403_.getRegistryName()).toList();
    }
}

